<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terms of Service - SpidyUrl | Service Agreement</title>
    <meta name="description" content="SpidyUrl Terms of Service - Read our terms and conditions for using our URL shortening service.">
    <meta name="keywords" content="terms of service, user agreement, SpidyUrl terms, service conditions">
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="canonical" href="https://spidyurl.com/terms.php">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://spidyurl.com/terms.php">
    <meta property="og:title" content="Terms of Service - SpidyUrl">
    <meta property="og:description" content="Read SpidyUrl's terms and conditions for using our URL shortening service.">
    <meta property="og:image" content="https://spidyurl.com/images/spider-logo-og.png">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://spidyurl.com/terms.php">
    <meta property="twitter:title" content="Terms of Service - SpidyUrl">
    <meta property="twitter:description" content="Read SpidyUrl's terms and conditions for using our URL shortening service.">
    <meta property="twitter:image" content="https://spidyurl.com/images/spider-logo-twitter.png">
</head>
<body>
    <div class="container">
        <nav style="margin-bottom: 2rem;">
            <a href="/" style="color: var(--primary-blue); text-decoration: none; font-weight: 600;">← Back to SpidyUrl</a>
        </nav>
        
        <div class="page-header">
            <h1>📋 Terms of Service</h1>
            <p>Please read these terms carefully before using our service</p>
            <p style="font-size: 0.875rem; opacity: 0.8;">Last updated: September 18, 2024</p>
        </div>
        
        <div class="content-wrapper">
            <div class="terms-intro">
                <p><strong>Welcome to SpidyUrl!</strong> These Terms of Service ("Terms") govern your use of our URL shortening service operated by SpidyUrl ("we," "us," or "our"). By accessing or using our service, you agree to be bound by these Terms.</p>
            </div>

            <div class="terms-section">
                <h2>1. Acceptance of Terms</h2>
                <p>By accessing and using SpidyUrl, you accept and agree to be bound by the terms and provision of this agreement. If you do not agree to abide by the above, please do not use this service.</p>
                <ul>
                    <li>These Terms apply to all visitors, users, and others who access the service</li>
                    <li>Your access and use of the service is conditioned on your acceptance of these Terms</li>
                    <li>If you disagree with any part of these terms, you may not access the service</li>
                </ul>
            </div>

            <div class="terms-section">
                <h2>2. Description of Service</h2>
                <p>SpidyUrl provides URL shortening services that allow users to create shortened versions of long URLs. Our service includes:</p>
                <ul>
                    <li>Free URL shortening without registration requirements</li>
                    <li>Permanent redirection services</li>
                    <li>Basic analytics and usage statistics</li>
                    <li>Duplicate URL detection</li>
                </ul>
            </div>

            <div class="terms-section">
                <h2>3. User Responsibilities</h2>
                <p>As a user of SpidyUrl, you agree to:</p>
                <ul>
                    <li><strong>Lawful Use:</strong> Use the service only for lawful purposes and in accordance with these Terms</li>
                    <li><strong>Accurate Information:</strong> Provide accurate and truthful information when using our service</li>
                    <li><strong>Respect Others:</strong> Not use the service to harm, harass, or violate the rights of others</li>
                    <li><strong>Compliance:</strong> Comply with all applicable local, state, national, and international laws</li>
                </ul>
            </div>

            <div class="terms-section">
                <h2>4. Prohibited Uses</h2>
                <p>You may not use our service for:</p>
                <div class="prohibited-grid">
                    <div class="prohibited-item">
                        <h3>🚫 Illegal Content</h3>
                        <ul>
                            <li>Illegal activities or content</li>
                            <li>Copyright infringement</li>
                            <li>Fraud or deception</li>
                        </ul>
                    </div>
                    <div class="prohibited-item">
                        <h3>🔞 Harmful Content</h3>
                        <ul>
                            <li>Malware or viruses</li>
                            <li>Phishing or spam</li>
                            <li>Adult or explicit content</li>
                        </ul>
                    </div>
                    <div class="prohibited-item">
                        <h3>⚠️ Abusive Behavior</h3>
                        <ul>
                            <li>Harassment or hate speech</li>
                            <li>Violence or threats</li>
                            <li>Discrimination</li>
                        </ul>
                    </div>
                    <div class="prohibited-item">
                        <h3>🔧 Technical Abuse</h3>
                        <ul>
                            <li>Service disruption</li>
                            <li>Unauthorized access</li>
                            <li>Excessive automated requests</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="terms-section">
                <h2>5. Service Availability</h2>
                <p>We strive to provide reliable service, but we cannot guarantee:</p>
                <ul>
                    <li><strong>Uptime:</strong> Continuous, uninterrupted access to our service</li>
                    <li><strong>Performance:</strong> Specific response times or performance levels</li>
                    <li><strong>Permanence:</strong> That shortened URLs will remain active indefinitely</li>
                </ul>
                <div class="service-note">
                    <p><strong>Note:</strong> We reserve the right to suspend or terminate the service at any time, with or without notice.</p>
                </div>
            </div>

            <div class="terms-section">
                <h2>6. Privacy and Data</h2>
                <p>Your privacy is important to us. Please review our Privacy Policy, which also governs your use of the service, to understand our practices.</p>
                <ul>
                    <li>We collect and use information as described in our <a href="/privacy.php">Privacy Policy</a></li>
                    <li>By using our service, you consent to the collection and use of this information</li>
                    <li>We implement security measures to protect your data</li>
                </ul>
            </div>

            <div class="terms-section">
                <h2>7. Intellectual Property</h2>
                <p>The service and its original content, features, and functionality are and will remain the exclusive property of SpidyUrl:</p>
                <ul>
                    <li><strong>Ownership:</strong> We own all rights to the service, including software, design, and content</li>
                    <li><strong>License:</strong> We grant you a limited license to use the service for personal or business purposes</li>
                    <li><strong>Restrictions:</strong> You may not copy, modify, distribute, or reverse engineer our service</li>
                </ul>
            </div>

            <div class="terms-section">
                <h2>8. Disclaimer of Warranties</h2>
                <p>Our service is provided "as is" and "as available" without any warranties:</p>
                <ul>
                    <li><strong>No Warranty:</strong> We disclaim all warranties, express or implied</li>
                    <li><strong>Fitness:</strong> We do not warrant that the service will meet your requirements</li>
                    <li><strong>Reliability:</strong> We do not guarantee the service will be error-free or uninterrupted</li>
                    <li><strong>Third-Party Content:</strong> We are not responsible for content accessed through shortened URLs</li>
                </ul>
            </div>

            <div class="terms-section">
                <h2>9. Limitation of Liability</h2>
                <p>To the fullest extent permitted by law, SpidyUrl shall not be liable for:</p>
                <ul>
                    <li>Any indirect, incidental, special, consequential, or punitive damages</li>
                    <li>Any loss of profits, revenues, data, or business opportunities</li>
                    <li>Any damages resulting from your use or inability to use the service</li>
                    <li>Any damages caused by third-party content or services</li>
                </ul>
            </div>

            <div class="terms-section">
                <h2>10. Indemnification</h2>
                <p>You agree to defend, indemnify, and hold harmless SpidyUrl from and against any claims, damages, costs, and expenses arising from:</p>
                <ul>
                    <li>Your use of the service</li>
                    <li>Your violation of these Terms</li>
                    <li>Your violation of any rights of another party</li>
                    <li>Any content you submit through the service</li>
                </ul>
            </div>

            <div class="terms-section">
                <h2>11. Termination</h2>
                <p>We may terminate or suspend your access to the service immediately, without prior notice, for any reason:</p>
                <ul>
                    <li><strong>Violation:</strong> If you breach these Terms</li>
                    <li><strong>Legal Requirements:</strong> If required by law or court order</li>
                    <li><strong>Service Discontinuation:</strong> If we decide to discontinue the service</li>
                </ul>
                <p>Upon termination, your right to use the service will cease immediately.</p>
            </div>

            <div class="terms-section">
                <h2>12. Governing Law</h2>
                <p>These Terms shall be governed by and construed in accordance with applicable laws, without regard to conflict of law provisions. Any disputes arising from these Terms or your use of the service shall be resolved through binding arbitration.</p>
            </div>

            <div class="terms-section">
                <h2>13. Changes to Terms</h2>
                <p>We reserve the right to modify or replace these Terms at any time:</p>
                <ul>
                    <li>We will provide notice of significant changes</li>
                    <li>Changes will be posted on this page with an updated effective date</li>
                    <li>Your continued use constitutes acceptance of the revised Terms</li>
                    <li>We encourage you to review these Terms periodically</li>
                </ul>
            </div>

            <div class="terms-section">
                <h2>14. Contact Information</h2>
                <p>If you have any questions about these Terms of Service, please contact us:</p>
                <div class="contact-details">
                    <p><strong>Email:</strong> <a href="mailto:legal@spidyurl.com">legal@spidyurl.com</a></p>
                    <p><strong>General Contact:</strong> <a href="mailto:contact@spidyurl.com">contact@spidyurl.com</a></p>
                    <p><strong>Contact Form:</strong> <a href="/contact.php">Contact Us</a></p>
                </div>
            </div>
        </div>
        
        <footer>
            <p>&copy; 2024 SpidyUrl. Professional URL Shortener Service.</p>
            <div class="footer-links">
                <a href="/">Home</a> |
                <a href="/about.php">About</a> |
                <a href="/contact.php">Contact</a> |
                <a href="/privacy.php">Privacy Policy</a> |
                <a href="/cookies.php">Cookie Policy</a>
            </div>
        </footer>
    </div>

    <style>
        body {
            padding-bottom: 4rem;
        }
        
        .page-header {
            text-align: center;
            margin-bottom: 3rem;
            padding: 2rem 0;
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--secondary-blue) 100%);
            color: white;
            border-radius: var(--border-radius-lg);
            margin: 0 -1rem 3rem;
        }

        .page-header h1 {
            font-size: clamp(2rem, 5vw, 3rem);
            margin-bottom: 0.5rem;
        }

        .content-wrapper {
            max-width: 800px;
            margin: 0 auto;
        }

        .terms-intro {
            background: var(--background-white);
            padding: 2rem;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
            margin-bottom: 2rem;
            font-size: 1.1rem;
            line-height: 1.7;
        }

        .terms-section {
            background: var(--background-white);
            padding: 2rem;
            margin-bottom: 2rem;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
        }

        .terms-section h2 {
            color: var(--primary-blue);
            margin-bottom: 1rem;
            font-size: 1.5rem;
            border-bottom: 2px solid var(--border-color);
            padding-bottom: 0.5rem;
        }

        .terms-section h3 {
            color: var(--text-dark);
            margin: 1rem 0 0.5rem;
            font-size: 1.1rem;
        }

        .terms-section ul {
            margin: 1rem 0;
            padding-left: 1.5rem;
        }

        .terms-section li {
            margin-bottom: 0.5rem;
            line-height: 1.6;
        }

        .prohibited-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-top: 1.5rem;
        }

        .prohibited-item {
            background: var(--background-light);
            padding: 1.5rem;
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
        }

        .prohibited-item h3 {
            color: var(--warning-red);
            margin-bottom: 1rem;
            font-size: 1rem;
        }

        .prohibited-item ul {
            margin: 0;
            padding-left: 1rem;
        }

        .prohibited-item li {
            font-size: 0.875rem;
            margin-bottom: 0.25rem;
        }

        .service-note {
            background: #fef3cd;
            border: 1px solid #fde047;
            border-left: 4px solid #f59e0b;
            padding: 1rem;
            border-radius: var(--border-radius);
            margin-top: 1rem;
        }

        .contact-details {
            background: var(--background-light);
            padding: 1.5rem;
            border-radius: var(--border-radius);
            margin-top: 1rem;
        }

        .contact-details a {
            color: var(--primary-blue);
            text-decoration: none;
        }

        .contact-details a:hover {
            text-decoration: underline;
        }

        .footer-links {
            margin-top: 1rem;
        }

        .footer-links a {
            color: var(--text-light);
            text-decoration: none;
            margin: 0 0.5rem;
        }

        .footer-links a:hover {
            color: var(--primary-blue);
        }

        @media (max-width: 768px) {
            .page-header {
                margin: 0 -0.5rem 2rem;
                padding: 1.5rem 1rem;
            }

            .terms-intro,
            .terms-section {
                padding: 1.5rem;
            }

            .prohibited-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .prohibited-item {
                padding: 1rem;
            }
        }
    </style>
</body>
</html>