<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cookie Policy - SpidyUrl | Cookie Information</title>
    <meta name="description" content="SpidyUrl Cookie Policy - Learn about how we use cookies and similar technologies on our website.">
    <meta name="keywords" content="cookie policy, cookies, tracking, SpidyUrl cookies, privacy">
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="canonical" href="https://spidyurl.com/cookies.php">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://spidyurl.com/cookies.php">
    <meta property="og:title" content="Cookie Policy - SpidyUrl">
    <meta property="og:description" content="Learn about how SpidyUrl uses cookies and similar technologies.">
    <meta property="og:image" content="https://spidyurl.com/images/spider-logo-og.png">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://spidyurl.com/cookies.php">
    <meta property="twitter:title" content="Cookie Policy - SpidyUrl">
    <meta property="twitter:description" content="Learn about how SpidyUrl uses cookies and similar technologies.">
    <meta property="twitter:image" content="https://spidyurl.com/images/spider-logo-twitter.png">
</head>
<body>
    <div class="container">
        <nav style="margin-bottom: 2rem;">
            <a href="/" style="color: var(--primary-blue); text-decoration: none; font-weight: 600;">← Back to SpidyUrl</a>
        </nav>
        
        <div class="page-header">
            <h1>🍪 Cookie Policy</h1>
            <p>Understanding how we use cookies and similar technologies</p>
            <p style="font-size: 0.875rem; opacity: 0.8;">Last updated: September 18, 2024</p>
        </div>
        
        <div class="content-wrapper">
            <div class="cookie-intro">
                <h2>What Are Cookies?</h2>
                <p>Cookies are small text files that are stored on your device when you visit a website. They help websites remember information about your visit, which can both make it easier to visit the site again and make the site more useful to you.</p>
            </div>

            <div class="cookie-section">
                <h2>How We Use Cookies</h2>
                <p>SpidyUrl uses cookies to enhance your browsing experience, analyze website performance, and serve relevant advertisements. Here's how we use different types of cookies:</p>
                
                <div class="cookie-types">
                    <div class="cookie-type">
                        <h3>🔧 Essential Cookies</h3>
                        <p><strong>Purpose:</strong> These cookies are necessary for the website to function properly.</p>
                        <p><strong>What they do:</strong></p>
                        <ul>
                            <li>Remember your preferences during your session</li>
                            <li>Enable core website functionality</li>
                            <li>Provide security features</li>
                            <li>Ensure the website works correctly</li>
                        </ul>
                        <p><strong>Can be disabled:</strong> No - these are required for the site to work</p>
                    </div>

                    <div class="cookie-type">
                        <h3>📊 Analytics Cookies</h3>
                        <p><strong>Purpose:</strong> Help us understand how visitors interact with our website.</p>
                        <p><strong>What they do:</strong></p>
                        <ul>
                            <li>Count visits and traffic sources</li>
                            <li>Measure website performance</li>
                            <li>Understand user behavior patterns</li>
                            <li>Help us improve our service</li>
                        </ul>
                        <p><strong>Can be disabled:</strong> Yes - through browser settings</p>
                    </div>

                    <div class="cookie-type">
                        <h3>📢 Advertising Cookies</h3>
                        <p><strong>Purpose:</strong> Used to display relevant advertisements and measure ad effectiveness.</p>
                        <p><strong>What they do:</strong></p>
                        <ul>
                            <li>Show relevant ads based on your interests</li>
                            <li>Prevent the same ad from being shown repeatedly</li>
                            <li>Measure advertising campaign effectiveness</li>
                            <li>Help fund our free service</li>
                        </ul>
                        <p><strong>Can be disabled:</strong> Yes - through browser settings or ad preferences</p>
                    </div>

                    <div class="cookie-type">
                        <h3>⚙️ Functional Cookies</h3>
                        <p><strong>Purpose:</strong> Enable enhanced functionality and personalization.</p>
                        <p><strong>What they do:</strong></p>
                        <ul>
                            <li>Remember your language preferences</li>
                            <li>Save your settings and choices</li>
                            <li>Provide enhanced features</li>
                            <li>Personalize your experience</li>
                        </ul>
                        <p><strong>Can be disabled:</strong> Yes - but may affect site functionality</p>
                    </div>
                </div>
            </div>

            <div class="cookie-section">
                <h2>Third-Party Cookies</h2>
                <p>We may use third-party services that set their own cookies. These include:</p>
                
                <div class="third-party-services">
                    <div class="service-item">
                        <h3>Google AdSense</h3>
                        <p><strong>Purpose:</strong> Display advertisements</p>
                        <p><strong>Cookies used:</strong> Various advertising and analytics cookies</p>
                        <p><strong>Privacy Policy:</strong> <a href="https://policies.google.com/privacy" target="_blank" rel="noopener">Google Privacy Policy</a></p>
                        <p><strong>Opt-out:</strong> <a href="https://adssettings.google.com" target="_blank" rel="noopener">Google Ad Settings</a></p>
                    </div>

                    <div class="service-item">
                        <h3>Google Analytics</h3>
                        <p><strong>Purpose:</strong> Website analytics and performance monitoring</p>
                        <p><strong>Cookies used:</strong> _ga, _gid, _gat cookies</p>
                        <p><strong>Privacy Policy:</strong> <a href="https://policies.google.com/privacy" target="_blank" rel="noopener">Google Privacy Policy</a></p>
                        <p><strong>Opt-out:</strong> <a href="https://tools.google.com/dlpage/gaoptout" target="_blank" rel="noopener">Google Analytics Opt-out</a></p>
                    </div>
                </div>
            </div>

            <div class="cookie-section">
                <h2>Cookie Management</h2>
                <p>You have several options for managing cookies:</p>

                <div class="management-options">
                    <div class="management-option">
                        <h3>🌐 Browser Settings</h3>
                        <p>Most web browsers allow you to control cookies through their settings:</p>
                        <ul>
                            <li><strong>Chrome:</strong> Settings → Privacy and security → Cookies and other site data</li>
                            <li><strong>Firefox:</strong> Options → Privacy & Security → Cookies and Site Data</li>
                            <li><strong>Safari:</strong> Preferences → Privacy → Cookies and website data</li>
                            <li><strong>Edge:</strong> Settings → Cookies and site permissions → Cookies and site data</li>
                        </ul>
                    </div>

                    <div class="management-option">
                        <h3>🎯 Ad Preferences</h3>
                        <p>You can manage advertising cookies through:</p>
                        <ul>
                            <li><a href="https://adssettings.google.com" target="_blank" rel="noopener">Google Ad Settings</a></li>
                            <li><a href="http://optout.aboutads.info/" target="_blank" rel="noopener">Digital Advertising Alliance</a></li>
                            <li><a href="http://optout.networkadvertising.org/" target="_blank" rel="noopener">Network Advertising Initiative</a></li>
                        </ul>
                    </div>

                    <div class="management-option">
                        <h3>📱 Mobile Devices</h3>
                        <p>On mobile devices, you can:</p>
                        <ul>
                            <li>Reset your advertising ID (iOS/Android)</li>
                            <li>Enable "Limit Ad Tracking" (iOS) or "Opt out of Ads Personalization" (Android)</li>
                            <li>Use browser settings to manage cookies</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="cookie-section">
                <h2>Cookie Retention</h2>
                <p>Different types of cookies are stored for different periods:</p>
                
                <div class="retention-info">
                    <div class="retention-item">
                        <h3>Session Cookies</h3>
                        <p>Deleted when you close your browser</p>
                    </div>
                    <div class="retention-item">
                        <h3>Persistent Cookies</h3>
                        <p>Stored for a specific period, typically 1-24 months</p>
                    </div>
                    <div class="retention-item">
                        <h3>Analytics Cookies</h3>
                        <p>Usually stored for 24-26 months</p>
                    </div>
                    <div class="retention-item">
                        <h3>Advertising Cookies</h3>
                        <p>Typically stored for 30 days to 2 years</p>
                    </div>
                </div>
            </div>

            <div class="cookie-section">
                <h2>Impact of Disabling Cookies</h2>
                <p>If you choose to disable cookies, please note that:</p>
                <ul>
                    <li><strong>Essential cookies:</strong> The website may not function properly</li>
                    <li><strong>Analytics cookies:</strong> We won't be able to improve our service based on usage data</li>
                    <li><strong>Advertising cookies:</strong> You may see less relevant advertisements</li>
                    <li><strong>Functional cookies:</strong> You may lose personalized features and preferences</li>
                </ul>
            </div>

            <div class="cookie-section">
                <h2>Updates to This Policy</h2>
                <p>We may update this Cookie Policy from time to time to reflect changes in our practices or for other operational, legal, or regulatory reasons. We encourage you to review this policy periodically.</p>
                <ul>
                    <li>Changes will be posted on this page</li>
                    <li>The "Last updated" date will be revised</li>
                    <li>Significant changes may be communicated via email or website notice</li>
                </ul>
            </div>

            <div class="cookie-section">
                <h2>Contact Us</h2>
                <p>If you have any questions about our use of cookies or this Cookie Policy, please contact us:</p>
                <div class="contact-details">
                    <p><strong>Email:</strong> <a href="mailto:privacy@spidyurl.com">privacy@spidyurl.com</a></p>
                    <p><strong>General Contact:</strong> <a href="mailto:contact@spidyurl.com">contact@spidyurl.com</a></p>
                    <p><strong>Contact Form:</strong> <a href="/contact.php">Contact Us</a></p>
                </div>
            </div>
        </div>
        
        <footer>
            <p>&copy; 2024 SpidyUrl. Professional URL Shortener Service.</p>
            <div class="footer-links">
                <a href="/">Home</a> |
                <a href="/about.php">About</a> |
                <a href="/contact.php">Contact</a> |
                <a href="/privacy.php">Privacy Policy</a> |
                <a href="/terms.php">Terms of Service</a>
            </div>
        </footer>
    </div>

    <style>
        body {
            padding-bottom: 4rem;
        }
        
        .page-header {
            text-align: center;
            margin-bottom: 3rem;
            padding: 2rem 0;
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--secondary-blue) 100%);
            color: white;
            border-radius: var(--border-radius-lg);
            margin: 0 -1rem 3rem;
        }

        .page-header h1 {
            font-size: clamp(2rem, 5vw, 3rem);
            margin-bottom: 0.5rem;
        }

        .content-wrapper {
            max-width: 800px;
            margin: 0 auto;
        }

        .cookie-intro {
            background: var(--background-white);
            padding: 2rem;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
            margin-bottom: 2rem;
        }

        .cookie-intro h2 {
            color: var(--primary-blue);
            margin-bottom: 1rem;
            font-size: 1.5rem;
        }

        .cookie-section {
            background: var(--background-white);
            padding: 2rem;
            margin-bottom: 2rem;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
        }

        .cookie-section h2 {
            color: var(--primary-blue);
            margin-bottom: 1rem;
            font-size: 1.5rem;
            border-bottom: 2px solid var(--border-color);
            padding-bottom: 0.5rem;
        }

        .cookie-types {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
            margin-top: 1.5rem;
        }

        .cookie-type {
            background: var(--background-light);
            padding: 1.5rem;
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
        }

        .cookie-type h3 {
            color: var(--primary-blue);
            margin-bottom: 1rem;
            font-size: 1.1rem;
        }

        .cookie-type ul {
            margin: 0.5rem 0;
            padding-left: 1.5rem;
        }

        .cookie-type li {
            margin-bottom: 0.25rem;
            font-size: 0.875rem;
        }

        .third-party-services {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
            margin-top: 1rem;
        }

        .service-item {
            background: var(--background-light);
            padding: 1.5rem;
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
        }

        .service-item h3 {
            color: var(--text-dark);
            margin-bottom: 1rem;
            font-size: 1.1rem;
        }

        .service-item a {
            color: var(--primary-blue);
            text-decoration: none;
        }

        .service-item a:hover {
            text-decoration: underline;
        }

        .management-options {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-top: 1rem;
        }

        .management-option {
            background: var(--background-light);
            padding: 1.5rem;
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
        }

        .management-option h3 {
            color: var(--primary-blue);
            margin-bottom: 1rem;
            font-size: 1.1rem;
        }

        .management-option ul {
            margin: 0.5rem 0;
            padding-left: 1.5rem;
        }

        .management-option li {
            margin-bottom: 0.5rem;
            font-size: 0.875rem;
        }

        .management-option a {
            color: var(--primary-blue);
            text-decoration: none;
        }

        .management-option a:hover {
            text-decoration: underline;
        }

        .retention-info {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-top: 1rem;
        }

        .retention-item {
            background: var(--background-light);
            padding: 1rem;
            border-radius: var(--border-radius);
            text-align: center;
            border: 1px solid var(--border-color);
        }

        .retention-item h3 {
            color: var(--primary-blue);
            margin-bottom: 0.5rem;
            font-size: 1rem;
        }

        .retention-item p {
            font-size: 0.875rem;
            color: var(--text-light);
            margin: 0;
        }

        .contact-details {
            background: var(--background-light);
            padding: 1.5rem;
            border-radius: var(--border-radius);
            margin-top: 1rem;
        }

        .contact-details a {
            color: var(--primary-blue);
            text-decoration: none;
        }

        .contact-details a:hover {
            text-decoration: underline;
        }

        .footer-links {
            margin-top: 1rem;
        }

        .footer-links a {
            color: var(--text-light);
            text-decoration: none;
            margin: 0 0.5rem;
        }

        .footer-links a:hover {
            color: var(--primary-blue);
        }

        @media (max-width: 768px) {
            .page-header {
                margin: 0 -0.5rem 2rem;
                padding: 1.5rem 1rem;
            }

            .cookie-intro,
            .cookie-section {
                padding: 1.5rem;
            }

            .cookie-types,
            .third-party-services,
            .management-options {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .retention-info {
                grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            }
        }
    </style>
</body>
</html>