<?php
require_once 'db.php';

echo "<h1>AntURL Debug Information</h1>";

try {
    $db = new Database();
    echo "<p style='color: green;'>✓ Database connection successful</p>";
    
    // Get all URLs from database
    $stmt = $db->getConnection()->prepare("SELECT * FROM urls ORDER BY created_at DESC LIMIT 10");
    $stmt->execute();
    $urls = $stmt->fetchAll();
    
    echo "<h2>Recent URLs in Database:</h2>";
    if (empty($urls)) {
        echo "<p>No URLs found in database. Try creating a short URL first.</p>";
    } else {
        echo "<table border='1' cellpadding='5' cellspacing='0'>";
        echo "<tr><th>ID</th><th>Short Code</th><th>Long URL</th><th>Created At</th><th>Test Link</th></tr>";
        foreach ($urls as $url) {
            $testLink = "http://" . $_SERVER['HTTP_HOST'] . "/" . $url['short_code'];
            echo "<tr>";
            echo "<td>" . htmlspecialchars($url['id']) . "</td>";
            echo "<td>" . htmlspecialchars($url['short_code']) . "</td>";
            echo "<td>" . htmlspecialchars($url['long_url']) . "</td>";
            echo "<td>" . htmlspecialchars($url['created_at']) . "</td>";
            echo "<td><a href='" . htmlspecialchars($testLink) . "' target='_blank'>Test</a></td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Database error: " . htmlspecialchars($e->getMessage()) . "</p>";
}

// Test URL parsing
echo "<h2>URL Parsing Test:</h2>";
$testUrls = [
    'google.com',
    'www.google.com',
    'http://google.com',
    'https://www.google.com',
    'https://github.com/user/repo'
];

foreach ($testUrls as $testUrl) {
    $processed = $testUrl;
    if (!preg_match('/^https?:\/\//', $processed)) {
        $processed = 'http://' . $processed;
    }
    $isValid = filter_var($processed, FILTER_VALIDATE_URL) !== false;
    echo "<p><strong>Original:</strong> " . htmlspecialchars($testUrl) . 
         " <strong>Processed:</strong> " . htmlspecialchars($processed) . 
         " <strong>Valid:</strong> " . ($isValid ? "✓" : "✗") . "</p>";
}

// Server information
echo "<h2>Server Information:</h2>";
echo "<p><strong>REQUEST_URI:</strong> " . htmlspecialchars($_SERVER['REQUEST_URI'] ?? 'Not set') . "</p>";
echo "<p><strong>HTTP_HOST:</strong> " . htmlspecialchars($_SERVER['HTTP_HOST'] ?? 'Not set') . "</p>";
echo "<p><strong>SCRIPT_NAME:</strong> " . htmlspecialchars($_SERVER['SCRIPT_NAME'] ?? 'Not set') . "</p>";
echo "<p><strong>PHP Version:</strong> " . phpversion() . "</p>";

// Test short code extraction
echo "<h2>Short Code Extraction Test:</h2>";
$testPaths = [
    '/abc123',
    '/debug.php',
    '/abc123?param=value',
    '/abc123/',
    '/index.php'
];

foreach ($testPaths as $path) {
    $matches = [];
    $found = preg_match('/\/([a-zA-Z0-9]{6})(?:\?.*)?$/', $path, $matches);
    echo "<p><strong>Path:</strong> " . htmlspecialchars($path) . 
         " <strong>Match:</strong> " . ($found ? "✓ (" . htmlspecialchars($matches[1]) . ")" : "✗") . "</p>";
}
?>