<?php
require_once 'db.php';

// Get the short code from the URL
$shortCode = '';
$requestUri = $_SERVER['REQUEST_URI'];

// Extract short code from URL (remove leading slash and any query parameters)
if (preg_match('/\/([a-zA-Z0-9]{6})(?:\?.*)?$/', $requestUri, $matches)) {
    $shortCode = $matches[1];
} else {
    // If no valid short code found, redirect to home page
    header('Location: /');
    exit;
}

try {
    $db = new Database();
    $urlData = $db->findByShortCode($shortCode);
    
    if ($urlData) {
        $longUrl = $urlData['long_url'];
        
        // Clean and normalize the URL
        $longUrl = trim($longUrl);
        
        // Ensure the URL has a protocol
        if (!preg_match('/^https?:\/\//', $longUrl)) {
            $longUrl = 'http://' . $longUrl;
        }
        
        // Validate the URL before redirecting
        if (filter_var($longUrl, FILTER_VALIDATE_URL) === false) {
            // Invalid URL in database, show error
            http_response_code(500);
            echo "<h1>Invalid URL</h1><p>The stored URL is invalid. Please contact the administrator.</p>";
            exit;
        }
        
        // Redirect to the original URL
        header('Location: ' . $longUrl, true, 301);
        exit;
    } else {
        // URL not found - show 404 page
        http_response_code(404);
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>URL Not Found - SpidyUrl</title>
            <link rel="stylesheet" href="/style.css">
            <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
        </head>
        <body>
            <div class="container">
                <div class="error-container">
                    <div class="error-icon">🔍</div>
                    <h1>URL Not Found</h1>
                    <p>The short URL you're looking for doesn't exist or may have been removed.</p>
                    <div class="error-details">
                        <p><strong>Short code:</strong> <?php echo htmlspecialchars($shortCode); ?></p>
                    </div>
                    <div class="error-actions">
                        <a href="/" class="btn-primary">Create New Short URL</a>
                        <a href="/" class="btn-secondary">Go Home</a>
                    </div>
                </div>
                
                <div class="suggestions">
                    <h3>What you can do:</h3>
                    <ul>
                        <li>Check if you typed the URL correctly</li>
                        <li>Contact the person who shared this link</li>
                        <li>Create a new short URL on our homepage</li>
                    </ul>
                </div>
            </div>
            
            <style>
                .error-container {
                    text-align: center;
                    padding: 3rem 2rem;
                    background: white;
                    border-radius: 12px;
                    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
                    margin: 2rem 0;
                }
                
                .error-icon {
                    font-size: 4rem;
                    margin-bottom: 1rem;
                }
                
                .error-container h1 {
                    color: #ef4444;
                    margin-bottom: 1rem;
                    font-size: 2rem;
                }
                
                .error-details {
                    background: #f8fafc;
                    padding: 1rem;
                    border-radius: 8px;
                    margin: 1.5rem 0;
                    font-family: 'Courier New', monospace;
                }
                
                .error-actions {
                    display: flex;
                    gap: 1rem;
                    justify-content: center;
                    flex-wrap: wrap;
                    margin-top: 2rem;
                }
                
                .btn-primary, .btn-secondary {
                    padding: 0.75rem 1.5rem;
                    border-radius: 8px;
                    text-decoration: none;
                    font-weight: 500;
                    transition: all 0.2s;
                }
                
                .btn-primary {
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    color: white;
                }
                
                .btn-secondary {
                    background: #e2e8f0;
                    color: #475569;
                }
                
                .btn-primary:hover {
                    transform: translateY(-2px);
                    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
                }
                
                .btn-secondary:hover {
                    background: #cbd5e1;
                }
                
                .suggestions {
                    background: white;
                    padding: 2rem;
                    border-radius: 12px;
                    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
                    text-align: left;
                }
                
                .suggestions h3 {
                    color: #1e293b;
                    margin-bottom: 1rem;
                }
                
                .suggestions ul {
                    list-style: none;
                    padding: 0;
                }
                
                .suggestions li {
                    padding: 0.5rem 0;
                    border-left: 3px solid #667eea;
                    padding-left: 1rem;
                    margin-bottom: 0.5rem;
                    background: #f8fafc;
                    border-radius: 0 8px 8px 0;
                }
                
                @media (max-width: 640px) {
                    .error-actions {
                        flex-direction: column;
                        align-items: center;
                    }
                    
                    .btn-primary, .btn-secondary {
                        width: 100%;
                        max-width: 200px;
                    }
                }
            </style>
        </body>
        </html>
        <?php
        exit;
    }
    
} catch (Exception $e) {
    // Database error - show error page
    http_response_code(500);
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Service Error - SpidyUrl</title>
        <link rel="stylesheet" href="/style.css">
    </head>
    <body>
        <div class="container">
            <div class="error-container">
                <div class="error-icon">⚠️</div>
                <h1>Service Temporarily Unavailable</h1>
                <p>We're experiencing technical difficulties. Please try again later.</p>
                <div class="error-actions">
                    <a href="/" class="btn-primary">Go Home</a>
                </div>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit;
}
?>