<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy - SpidyUrl | Your Privacy Matters</title>
    <meta name="description" content="SpidyUrl Privacy Policy - Learn how we protect your privacy and handle your data when using our URL shortening service.">
    <meta name="keywords" content="privacy policy, data protection, SpidyUrl privacy, GDPR compliance">
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="canonical" href="https://spidyurl.com/privacy.php">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://spidyurl.com/privacy.php">
    <meta property="og:title" content="Privacy Policy - SpidyUrl">
    <meta property="og:description" content="Learn how SpidyUrl protects your privacy and handles your data.">
    <meta property="og:image" content="https://spidyurl.com/images/spider-logo-og.png">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://spidyurl.com/privacy.php">
    <meta property="twitter:title" content="Privacy Policy - SpidyUrl">
    <meta property="twitter:description" content="Learn how SpidyUrl protects your privacy and handles your data.">
    <meta property="twitter:image" content="https://spidyurl.com/images/spider-logo-twitter.png">
</head>
<body>
    <div class="container">
        <nav style="margin-bottom: 2rem;">
            <a href="/" style="color: var(--primary-blue); text-decoration: none; font-weight: 600;">← Back to SpidyUrl</a>
        </nav>
        
        <div class="page-header">
            <h1>🔒 Privacy Policy</h1>
            <p>Your privacy is important to us</p>
            <p style="font-size: 0.875rem; opacity: 0.8;">Last updated: September 18, 2024</p>
        </div>
        
        <div class="content-wrapper">
            <div class="toc-section">
                <h2>Table of Contents</h2>
                <ul class="toc-list">
                    <li><a href="#information-collection">Information We Collect</a></li>
                    <li><a href="#information-use">How We Use Information</a></li>
                    <li><a href="#information-sharing">Information Sharing</a></li>
                    <li><a href="#data-security">Data Security</a></li>
                    <li><a href="#cookies">Cookies and Tracking</a></li>
                    <li><a href="#third-party">Third-Party Services</a></li>
                    <li><a href="#user-rights">Your Rights</a></li>
                    <li><a href="#data-retention">Data Retention</a></li>
                    <li><a href="#policy-updates">Policy Updates</a></li>
                    <li><a href="#contact">Contact Information</a></li>
                </ul>
            </div>

            <div class="policy-section" id="information-collection">
                <h2>1. Information We Collect</h2>
                
                <h3>Information You Provide</h3>
                <ul>
                    <li><strong>URLs:</strong> The original long URLs you submit for shortening</li>
                    <li><strong>Contact Information:</strong> When you contact us (name, email, message content)</li>
                    <li><strong>Feedback:</strong> Any feedback or suggestions you provide</li>
                </ul>
                
                <h3>Automatically Collected Information</h3>
                <ul>
                    <li><strong>Usage Data:</strong> How you interact with our service</li>
                    <li><strong>Technical Data:</strong> IP address, browser type, device information</li>
                    <li><strong>Analytics Data:</strong> Page views, click data, referrer information</li>
                </ul>
            </div>

            <div class="policy-section" id="information-use">
                <h2>2. How We Use Information</h2>
                <p>We use the collected information for the following purposes:</p>
                <ul>
                    <li><strong>Service Provision:</strong> To create and manage shortened URLs</li>
                    <li><strong>Service Improvement:</strong> To analyze usage patterns and improve our service</li>
                    <li><strong>Communication:</strong> To respond to your inquiries and provide support</li>
                    <li><strong>Security:</strong> To protect against fraud, abuse, and security threats</li>
                    <li><strong>Legal Compliance:</strong> To comply with applicable laws and regulations</li>
                </ul>
            </div>

            <div class="policy-section" id="information-sharing">
                <h2>3. Information Sharing</h2>
                <p>We do not sell, trade, or rent your personal information to third parties. We may share information in the following limited circumstances:</p>
                <ul>
                    <li><strong>Legal Requirements:</strong> When required by law or to protect our rights</li>
                    <li><strong>Service Providers:</strong> With trusted partners who assist in operating our service</li>
                    <li><strong>Safety:</strong> To protect the safety of our users or the public</li>
                    <li><strong>Business Transfer:</strong> In connection with a merger, acquisition, or sale of assets</li>
                </ul>
            </div>

            <div class="policy-section" id="data-security">
                <h2>4. Data Security</h2>
                <p>We implement appropriate security measures to protect your information:</p>
                <ul>
                    <li><strong>Encryption:</strong> Data transmission is protected using SSL/TLS encryption</li>
                    <li><strong>Access Controls:</strong> Limited access to personal data on a need-to-know basis</li>
                    <li><strong>Regular Updates:</strong> We regularly update our security practices and systems</li>
                    <li><strong>Monitoring:</strong> Continuous monitoring for security threats and vulnerabilities</li>
                </ul>
                <div class="security-note">
                    <p><strong>Note:</strong> While we strive to protect your information, no method of transmission over the internet is 100% secure.</p>
                </div>
            </div>

            <div class="policy-section" id="cookies">
                <h2>5. Cookies and Tracking</h2>
                <p>We use cookies and similar technologies to enhance your experience:</p>
                
                <h3>Types of Cookies We Use</h3>
                <ul>
                    <li><strong>Essential Cookies:</strong> Necessary for the website to function properly</li>
                    <li><strong>Analytics Cookies:</strong> Help us understand how visitors use our website</li>
                    <li><strong>Advertising Cookies:</strong> Used to display relevant advertisements</li>
                </ul>
                
                <p>You can control cookies through your browser settings. However, disabling certain cookies may affect website functionality.</p>
                <p><a href="/cookies.php">Learn more about our Cookie Policy</a></p>
            </div>

            <div class="policy-section" id="third-party">
                <h2>6. Third-Party Services</h2>
                <p>Our website may contain links to third-party websites or integrate with third-party services:</p>
                <ul>
                    <li><strong>Google AdSense:</strong> For displaying advertisements</li>
                    <li><strong>Analytics Services:</strong> For website analytics and performance monitoring</li>
                    <li><strong>External Links:</strong> Links to third-party websites are not under our control</li>
                </ul>
                <p>We are not responsible for the privacy practices of third-party websites or services.</p>
            </div>

            <div class="policy-section" id="user-rights">
                <h2>7. Your Rights</h2>
                <p>Depending on your location, you may have the following rights regarding your personal information:</p>
                <ul>
                    <li><strong>Access:</strong> Right to know what personal information we have about you</li>
                    <li><strong>Correction:</strong> Right to correct inaccurate personal information</li>
                    <li><strong>Deletion:</strong> Right to request deletion of your personal information</li>
                    <li><strong>Portability:</strong> Right to receive your data in a portable format</li>
                    <li><strong>Objection:</strong> Right to object to certain processing of your data</li>
                </ul>
                <p>To exercise these rights, please contact us at <a href="mailto:privacy@spidyurl.com">privacy@spidyurl.com</a></p>
            </div>

            <div class="policy-section" id="data-retention">
                <h2>8. Data Retention</h2>
                <p>We retain your information for the following periods:</p>
                <ul>
                    <li><strong>URL Data:</strong> Retained indefinitely to ensure shortened URLs continue to work</li>
                    <li><strong>Analytics Data:</strong> Retained for up to 26 months</li>
                    <li><strong>Contact Information:</strong> Retained for up to 3 years after last contact</li>
                    <li><strong>Technical Logs:</strong> Retained for up to 12 months</li>
                </ul>
            </div>

            <div class="policy-section" id="policy-updates">
                <h2>9. Policy Updates</h2>
                <p>We may update this Privacy Policy from time to time. When we do:</p>
                <ul>
                    <li>We will post the updated policy on this page</li>
                    <li>We will update the "Last updated" date at the top of this policy</li>
                    <li>We may notify you of significant changes via email or website notice</li>
                    <li>Your continued use of our service constitutes acceptance of the updated policy</li>
                </ul>
            </div>

            <div class="policy-section" id="contact">
                <h2>10. Contact Information</h2>
                <p>If you have any questions about this Privacy Policy or our data practices, please contact us:</p>
                <div class="contact-details">
                    <p><strong>Email:</strong> <a href="mailto:privacy@spidyurl.com">privacy@spidyurl.com</a></p>
                    <p><strong>General Contact:</strong> <a href="mailto:contact@spidyurl.com">contact@spidyurl.com</a></p>
                    <p><strong>Website:</strong> <a href="/">https://spidyurl.com</a></p>
                </div>
            </div>
        </div>
        
        <footer>
            <p>&copy; 2024 SpidyUrl. Professional URL Shortener Service.</p>
            <div class="footer-links">
                <a href="/">Home</a> |
                <a href="/about.php">About</a> |
                <a href="/contact.php">Contact</a> |
                <a href="/blog.php">Blog</a> |
                <a href="/terms.php">Terms of Service</a> |
                <a href="/cookies.php">Cookie Policy</a>
            </div>
        </footer>
    </div>

    <style>
        body {
            padding-bottom: 4rem;
        }
        
        .page-header {
            text-align: center;
            margin-bottom: 3rem;
            padding: 2rem 0;
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--secondary-blue) 100%);
            color: white;
            border-radius: var(--border-radius-lg);
            margin: 0 -1rem 3rem;
        }

        .page-header h1 {
            font-size: clamp(2rem, 5vw, 3rem);
            margin-bottom: 0.5rem;
        }

        .content-wrapper {
            max-width: 800px;
            margin: 0 auto;
        }

        .toc-section {
            background: var(--background-white);
            padding: 2rem;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
            margin-bottom: 2rem;
        }

        .toc-section h2 {
            color: var(--primary-blue);
            margin-bottom: 1rem;
            font-size: 1.5rem;
        }

        .toc-list {
            list-style: none;
            padding: 0;
            columns: 2;
            column-gap: 2rem;
        }

        .toc-list li {
            margin-bottom: 0.5rem;
            break-inside: avoid;
        }

        .toc-list a {
            color: var(--primary-blue);
            text-decoration: none;
            font-weight: 500;
        }

        .toc-list a:hover {
            text-decoration: underline;
        }

        .policy-section {
            background: var(--background-white);
            padding: 2rem;
            margin-bottom: 2rem;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
        }

        .policy-section h2 {
            color: var(--primary-blue);
            margin-bottom: 1rem;
            font-size: 1.5rem;
            border-bottom: 2px solid var(--border-color);
            padding-bottom: 0.5rem;
        }

        .policy-section h3 {
            color: var(--text-dark);
            margin: 1.5rem 0 0.75rem;
            font-size: 1.1rem;
        }

        .policy-section ul {
            margin: 1rem 0;
            padding-left: 1.5rem;
        }

        .policy-section li {
            margin-bottom: 0.5rem;
            line-height: 1.6;
        }

        .security-note {
            background: #fef3cd;
            border: 1px solid #fde047;
            border-left: 4px solid #f59e0b;
            padding: 1rem;
            border-radius: var(--border-radius);
            margin-top: 1rem;
        }

        .contact-details {
            background: var(--background-light);
            padding: 1.5rem;
            border-radius: var(--border-radius);
            margin-top: 1rem;
        }

        .contact-details a {
            color: var(--primary-blue);
            text-decoration: none;
        }

        .contact-details a:hover {
            text-decoration: underline;
        }

        .footer-links {
            margin-top: 1rem;
        }

        .footer-links a {
            color: var(--text-light);
            text-decoration: none;
            margin: 0 0.5rem;
        }

        .footer-links a:hover {
            color: var(--primary-blue);
        }

        @media (max-width: 768px) {
            .page-header {
                margin: 0 -0.5rem 2rem;
                padding: 1.5rem 1rem;
            }

            .toc-section,
            .policy-section {
                padding: 1.5rem;
            }

            .toc-list {
                columns: 1;
            }
        }
    </style>
</body>
</html>