<?php
class Database {
    private $host = 'localhost';
    private $dbname = 'premiump_email';
    private $username = 'premiump_antor';
    private $password = 'AntorNusrat@@13';
    private $pdo;
    
    public function __construct() {
        try {
            $dsn = "mysql:host={$this->host};dbname={$this->dbname};charset=utf8mb4";
            $this->pdo = new PDO($dsn, $this->username, $this->password, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]);
        } catch (PDOException $e) {
            die("Database connection failed: " . $e->getMessage());
        }
    }
    
    public function getConnection() {
        return $this->pdo;
    }
    
    public function insertUrl($longUrl, $shortCode) {
        $stmt = $this->pdo->prepare("INSERT INTO urls (long_url, short_code) VALUES (?, ?)");
        return $stmt->execute([$longUrl, $shortCode]);
    }
    
    public function findByShortCode($shortCode) {
        $stmt = $this->pdo->prepare("SELECT * FROM urls WHERE short_code = ?");
        $stmt->execute([$shortCode]);
        return $stmt->fetch();
    }
    
    public function findByLongUrl($longUrl) {
        $stmt = $this->pdo->prepare("SELECT * FROM urls WHERE long_url = ?");
        $stmt->execute([$longUrl]);
        return $stmt->fetch();
    }
    
    public function shortCodeExists($shortCode) {
        $stmt = $this->pdo->prepare("SELECT COUNT(*) FROM urls WHERE short_code = ?");
        $stmt->execute([$shortCode]);
        return $stmt->fetchColumn() > 0;
    }
}
?>