<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - SpidyUrl | Get in Touch</title>
    <meta name="description" content="Contact SpidyUrl for support, feedback, or business inquiries. We're here to help with your URL shortening needs.">
    <meta name="keywords" content="contact SpidyUrl, support, feedback, business inquiries">
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="canonical" href="https://spidyurl.com/contact.php">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://spidyurl.com/contact.php">
    <meta property="og:title" content="Contact SpidyUrl - Get in Touch">
    <meta property="og:description" content="Contact SpidyUrl for support, feedback, or business inquiries. We're here to help.">
    <meta property="og:image" content="https://spidyurl.com/images/spider-logo-og.png">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://spidyurl.com/contact.php">
    <meta property="twitter:title" content="Contact SpidyUrl - Get in Touch">
    <meta property="twitter:description" content="Contact SpidyUrl for support, feedback, or business inquiries. We're here to help.">
    <meta property="twitter:image" content="https://spidyurl.com/images/spider-logo-twitter.png">
</head>
<body>
    <div class="container">
        <nav style="margin-bottom: 2rem;">
            <a href="/" style="color: var(--primary-blue); text-decoration: none; font-weight: 600;">← Back to SpidyUrl</a>
        </nav>
        
        <div class="page-header">
            <h1>📞 Contact Us</h1>
            <p>We'd love to hear from you! Get in touch with our team.</p>
        </div>
        
        <div class="content-wrapper">
            <div class="contact-grid">
                <div class="contact-form-section">
                    <h2>Send us a Message</h2>
                    <form class="contact-form" action="#" method="POST">
                        <div class="form-row">
                            <div class="form-group">
                                <label for="name">Full Name *</label>
                                <input type="text" id="name" name="name" required>
                            </div>
                            <div class="form-group">
                                <label for="email">Email Address *</label>
                                <input type="email" id="email" name="email" required>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="subject">Subject *</label>
                            <select id="subject" name="subject" required>
                                <option value="">Please select a subject</option>
                                <option value="general">General Inquiry</option>
                                <option value="support">Technical Support</option>
                                <option value="business">Business Partnership</option>
                                <option value="feedback">Feedback & Suggestions</option>
                                <option value="bug">Bug Report</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="message">Message *</label>
                            <textarea id="message" name="message" rows="6" placeholder="Tell us how we can help you..." required></textarea>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Send Message</button>
                    </form>
                </div>
                
                <div class="contact-info-section">
                    <h2>Get in Touch</h2>
                    
                    <div class="contact-method">
                        <h3>📧 Email Support</h3>
                        <p><a href="mailto:support@spidyurl.com">support@spidyurl.com</a></p>
                        <p class="contact-note">For technical support and general inquiries</p>
                    </div>
                    
                    <div class="contact-method">
                        <h3>🏢 Business Inquiries</h3>
                        <p><a href="mailto:business@spidyurl.com">business@spidyurl.com</a></p>
                        <p class="contact-note">For partnerships and business opportunities</p>
                    </div>
                    
                    <div class="contact-method">
                        <h3>⏰ Response Time</h3>
                        <p>We typically respond within 24-48 hours during business days.</p>
                    </div>
                    
                    <div class="contact-method">
                        <h3>🌐 Follow Us</h3>
                        <div class="social-links">
                            <a href="#" class="social-link">Twitter</a>
                            <a href="#" class="social-link">LinkedIn</a>
                            <a href="#" class="social-link">GitHub</a>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="faq-section">
                <h2>Frequently Asked Questions</h2>
                <div class="faq-grid">
                    <div class="faq-item">
                        <h3>How do I report a broken link?</h3>
                        <p>Please email us at support@spidyurl.com with the short URL that's not working, and we'll investigate immediately.</p>
                    </div>
                    <div class="faq-item">
                        <h3>Can I customize my short URLs?</h3>
                        <p>Currently, we generate random 6-character codes for all URLs. Custom URLs may be available in future updates.</p>
                    </div>
                    <div class="faq-item">
                        <h3>Is there a limit to how many URLs I can shorten?</h3>
                        <p>No, there's no limit! You can shorten as many URLs as you need, completely free.</p>
                    </div>
                    <div class="faq-item">
                        <h3>How long do shortened URLs last?</h3>
                        <p>Our shortened URLs are permanent and will continue to work indefinitely unless there are policy violations.</p>
                    </div>
                </div>
            </div>
        </div>
        
        <footer>
            <p>&copy; 2024 SpidyUrl. Professional URL Shortener Service.</p>
            <div class="footer-links">
                <a href="/">Home</a> |
                <a href="/about.php">About</a> |
                <a href="/blog.php">Blog</a> |
                <a href="/privacy.php">Privacy Policy</a> |
                <a href="/terms.php">Terms of Service</a> |
                <a href="/cookies.php">Cookie Policy</a>
            </div>
        </footer>
    </div>

    <style>
        body {
            padding-bottom: 4rem;
        }
        
        .page-header {
            text-align: center;
            margin-bottom: 3rem;
            padding: 2rem 0;
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--secondary-blue) 100%);
            color: white;
            border-radius: var(--border-radius-lg);
            margin: 0 -1rem 3rem;
        }

        .page-header h1 {
            font-size: clamp(2rem, 5vw, 3rem);
            margin-bottom: 0.5rem;
        }

        .content-wrapper {
            max-width: 1000px;
            margin: 0 auto;
        }

        .contact-grid {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 3rem;
            margin-bottom: 3rem;
        }

        .contact-form-section, .contact-info-section {
            background: var(--background-white);
            padding: 2rem;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
        }

        .contact-form-section h2, .contact-info-section h2 {
            color: var(--primary-blue);
            margin-bottom: 1.5rem;
            font-size: 1.5rem;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: var(--text-dark);
        }

        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 2px solid var(--border-color);
            border-radius: var(--border-radius);
            font-size: 1rem;
            transition: var(--transition);
            background: var(--background-white);
            color: var(--text-dark);
        }

        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 3px rgba(30, 64, 175, 0.1);
        }

        .form-group textarea {
            resize: vertical;
            min-height: 120px;
        }

        .contact-method {
            margin-bottom: 2rem;
            padding: 1.5rem;
            background: var(--background-light);
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
        }

        .contact-method h3 {
            color: var(--primary-blue);
            margin-bottom: 0.5rem;
            font-size: 1.1rem;
        }

        .contact-method a {
            color: var(--primary-blue);
            text-decoration: none;
            font-weight: 500;
        }

        .contact-method a:hover {
            text-decoration: underline;
        }

        .contact-note {
            font-size: 0.875rem;
            color: var(--text-light);
            margin-top: 0.25rem;
        }

        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 0.5rem;
        }

        .social-link {
            padding: 0.5rem 1rem;
            background: var(--primary-blue);
            color: white;
            text-decoration: none;
            border-radius: var(--border-radius);
            font-size: 0.875rem;
            transition: var(--transition);
        }

        .social-link:hover {
            background: var(--primary-blue-dark);
            transform: translateY(-1px);
        }

        .faq-section {
            background: var(--background-white);
            padding: 2rem;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
        }

        .faq-section h2 {
            color: var(--primary-blue);
            margin-bottom: 1.5rem;
            font-size: 1.5rem;
        }

        .faq-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
        }

        .faq-item {
            padding: 1.5rem;
            background: var(--background-light);
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
        }

        .faq-item h3 {
            color: var(--text-dark);
            margin-bottom: 0.75rem;
            font-size: 1rem;
        }

        .faq-item p {
            color: var(--text-light);
            font-size: 0.875rem;
            line-height: 1.5;
        }

        .footer-links {
            margin-top: 1rem;
        }

        .footer-links a {
            color: var(--text-light);
            text-decoration: none;
            margin: 0 0.5rem;
        }

        .footer-links a:hover {
            color: var(--primary-blue);
        }

        @media (max-width: 768px) {
            .page-header {
                margin: 0 -0.5rem 2rem;
                padding: 1.5rem 1rem;
            }

            .contact-grid {
                grid-template-columns: 1fr;
                gap: 2rem;
            }

            .form-row {
                grid-template-columns: 1fr;
            }

            .contact-form-section,
            .contact-info-section,
            .faq-section {
                padding: 1.5rem;
            }

            .faq-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .social-links {
                flex-wrap: wrap;
            }
        }
    </style>
</body>
</html>