<?php
include 'db.php';

// Create a new Database instance and get the PDO connection
$db = new Database();
$pdo = $db->getConnection();

// Fetch blog posts from the database
$sql = "SELECT * FROM blog ORDER BY created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$posts = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Blog</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="blog.css">
</head>
<body>
    <header>
        <nav>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li><a href="about.php">About</a></li>
                <li><a href="contact.php">Contact</a></li>
                <li><a href="blog.php">Blog</a></li>
            </ul>
        </nav>
    </header>

    <main class="blog-container">
        <div class="blog-header">
            <h1>Our Blog</h1>
            <p>Latest news and updates</p>
        </div>

        <?php if (count($posts) > 0): ?>
            <?php 
            $featured_post = array_shift($posts);
            ?>
            <div class="featured-post">
                <?php if ($featured_post['image']): ?>
                    <img src="uploads/<?php echo $featured_post['image']; ?>" alt="<?php echo htmlspecialchars($featured_post['title']); ?>" style="width:100%; height:auto; border-radius: 8px; margin-bottom: 1.5rem;">
                <?php endif; ?>
                <h2><?php echo htmlspecialchars($featured_post['title']); ?></h2>
                <p class="post-meta">Posted on <?php echo date('F j, Y', strtotime($featured_post['created_at'])); ?></p>
                <div class="post-excerpt">
                    <?php echo nl2br(htmlspecialchars(substr($featured_post['content'], 0, 200))); ?>...
                </div>
                <a href="#" class="read-more">Read More</a>
            </div>

            <div class="blog-grid">
                <?php foreach($posts as $row): ?>
                    <div class="blog-post">
                        <?php if ($row['image']): ?>
                            <img src="uploads/<?php echo $row['image']; ?>" alt="<?php echo htmlspecialchars($row['title']); ?>" style="width:100%; height:auto; border-top-left-radius: 8px; border-top-right-radius: 8px;">
                        <?php endif; ?>
                        <div class="post-content-wrapper">
                            <h2><?php echo htmlspecialchars($row['title']); ?></h2>
                            <p class="post-meta">Posted on <?php echo date('F j, Y', strtotime($row['created_at'])); ?></p>
                            <div class="post-excerpt">
                                <?php echo nl2br(htmlspecialchars(substr($row['content'], 0, 150))); ?>...
                            </div>
                            <a href="#" class="read-more">Read More</a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p style="text-align: center;">No blog posts yet. Stay tuned!</p>
        <?php endif; ?>
    </main>

    <footer>
        <p>&copy; <?php echo date('Y'); ?> Your URL Shortener. All rights reserved.</p>
    </footer>
</body>
</html>
