<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel</title>
    <link rel="stylesheet" href="admin.css">
</head>
<body>
    <header>
        <h1>Admin Panel</h1>
        <nav>
            <a href="../index.php" target="_blank">View Site</a>
            <a href="logout.php">Logout</a>
        </nav>
    </header>

    <main class="admin-container">
        <div class="toolbar">
            <button id="add-post-btn" class="btn btn-primary">Create Post</button>
        </div>

        <table>
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody id="posts-table-body"></tbody>
        </table>
    </main>

    <!-- Modal for Add/Edit Post -->
    <div id="post-modal" class="modal">
        <div class="modal-content">
            <span class="close-btn">&times;</span>
            <h2 id="modal-title"></h2>
            <form id="post-form" enctype="multipart/form-data">
                <input type="hidden" id="post-id" name="id">
                <div class="form-group">
                    <label for="title">Title</label>
                    <input type="text" id="title" name="title" required>
                </div>
                <div class="form-group">
                    <label for="content">Content</label>
                    <textarea id="content" name="content" rows="10" required></textarea>
                </div>
                <div class="form-group">
                    <label for="image">Image</label>
                    <input type="file" id="image" name="image">
                    <input type="hidden" id="existing-image" name="existing_image">
                </div>
                <button type="submit" class="btn btn-primary">Save</button>
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const addPostBtn = document.getElementById('add-post-btn');
            const postModal = document.getElementById('post-modal');
            const closeModalBtn = document.querySelector('.close-btn');
            const postForm = document.getElementById('post-form');
            const modalTitle = document.getElementById('modal-title');
            const postsTableBody = document.getElementById('posts-table-body');

            const openModal = (title, post = null) => {
                modalTitle.textContent = title;
                postForm.reset();
                document.getElementById('post-id').value = '';
                document.getElementById('existing-image').value = '';

                if (post) {
                    document.getElementById('post-id').value = post.id;
                    document.getElementById('title').value = post.title;
                    document.getElementById('content').value = post.content;
                    document.getElementById('existing-image').value = post.image;
                }
                postModal.style.display = 'block';
            };

            const closeModal = () => {
                postModal.style.display = 'none';
            };

            const fetchPosts = async () => {
                const response = await fetch('api.php?action=get_posts');
                const result = await response.json();

                if (result.success) {
                    postsTableBody.innerHTML = '';
                    result.posts.forEach(post => {
                        const row = document.createElement('tr');
                        row.innerHTML = `
                            <td>${post.title}</td>
                            <td>${new Date(post.created_at).toLocaleDateString()}</td>
                            <td class="actions">
                                <button class="btn btn-edit" data-id="${post.id}">Edit</button>
                                <button class="btn btn-delete" data-id="${post.id}">Delete</button>
                            </td>
                        `;
                        postsTableBody.appendChild(row);
                    });
                }
            };

            addPostBtn.addEventListener('click', () => openModal('Create Post'));
            closeModalBtn.addEventListener('click', closeModal);
            window.addEventListener('click', (e) => {
                if (e.target === postModal) {
                    closeModal();
                }
            });

            postForm.addEventListener('submit', async (e) => {
                e.preventDefault();
                const formData = new FormData(postForm);
                const id = document.getElementById('post-id').value;
                const action = id ? 'update_post' : 'create_post';
                formData.append('action', action);

                const response = await fetch('api.php', {
                    method: 'POST',
                    body: formData
                });

                const result = await response.json();
                if (result.success) {
                    closeModal();
                    fetchPosts();
                } else {
                    alert(result.message);
                }
            });

            postsTableBody.addEventListener('click', async (e) => {
                if (e.target.classList.contains('btn-edit')) {
                    const id = e.target.dataset.id;
                    const response = await fetch('api.php?action=get_posts');
                    const result = await response.json();
                    if (result.success) {
                        const post = result.posts.find(p => p.id == id);
                        if (post) {
                            openModal('Edit Post', post);
                        }
                    }
                } else if (e.target.classList.contains('btn-delete')) {
                    const id = e.target.dataset.id;
                    if (confirm('Are you sure you want to delete this post?')) {
                        const formData = new FormData();
                        formData.append('action', 'delete_post');
                        formData.append('id', id);

                        const response = await fetch('api.php', {
                            method: 'POST',
                            body: formData
                        });

                        const result = await response.json();
                        if (result.success) {
                            fetchPosts();
                        } else {
                            alert(result.message);
                        }
                    }
                }
            });

            fetchPosts();
        });
    </script>
</body>
</html>
