<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

include '../db.php';

$action = $_REQUEST['action'] ?? '';

$db = new Database();
$pdo = $db->getConnection();

switch ($action) {
    case 'get_posts':
        $stmt = $pdo->query("SELECT * FROM blog ORDER BY created_at DESC");
        $posts = $stmt->fetchAll();
        echo json_encode(['success' => true, 'posts' => $posts]);
        break;

    case 'create_post':
        $title = $_POST['title'];
        $content = $_POST['content'];
        $image = null;

        if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../uploads/';
            $image_name = uniqid() . '-' . basename($_FILES['image']['name']);
            $target_file = $upload_dir . $image_name;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
                $image = $image_name;
            }
        }

        $stmt = $pdo->prepare("INSERT INTO blog (title, content, image) VALUES (?, ?, ?)");
        if ($stmt->execute([$title, $content, $image])) {
            echo json_encode(['success' => true, 'message' => 'Post created successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to create post.']);
        }
        break;

    case 'update_post':
        $id = $_POST['id'];
        $title = $_POST['title'];
        $content = $_POST['content'];
        $image = $_POST['existing_image'] ?? null;

        if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../uploads/';
            $image_name = uniqid() . '-' . basename($_FILES['image']['name']);
            $target_file = $upload_dir . $image_name;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
                $image = $image_name;
            }
        }

        $stmt = $pdo->prepare("UPDATE blog SET title = ?, content = ?, image = ? WHERE id = ?");
        if ($stmt->execute([$title, $content, $image, $id])) {
            echo json_encode(['success' => true, 'message' => 'Post updated successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update post.']);
        }
        break;

    case 'delete_post':
        $id = $_POST['id'];
        $stmt = $pdo->prepare("DELETE FROM blog WHERE id = ?");
        if ($stmt->execute([$id])) {
            echo json_encode(['success' => true, 'message' => 'Post deleted successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to delete post.']);
        }
        break;

    default:
        echo json_encode(['success' => false, 'message' => 'Invalid action.']);
        break;
}
