<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us - SpidyUrl | Professional URL Shortener</title>
    <meta name="description" content="Learn about SpidyUrl, the professional URL shortening service that helps you create clean, trackable links for better web experience.">
    <meta name="keywords" content="about SpidyUrl, URL shortener, link management, web tools">
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="canonical" href="https://spidyurl.com/about.php">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://spidyurl.com/about.php">
    <meta property="og:title" content="About SpidyUrl - Professional URL Shortener">
    <meta property="og:description" content="Learn about SpidyUrl, the professional URL shortening service that helps you create clean, trackable links.">
    <meta property="og:image" content="https://spidyurl.com/images/spider-logo-og.png">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://spidyurl.com/about.php">
    <meta property="twitter:title" content="About SpidyUrl - Professional URL Shortener">
    <meta property="twitter:description" content="Learn about SpidyUrl, the professional URL shortening service that helps you create clean, trackable links.">
    <meta property="twitter:image" content="https://spidyurl.com/images/spider-logo-twitter.png">
</head>
<body>
    <div class="container">
        <nav style="margin-bottom: 2rem;">
            <a href="/" style="color: var(--primary-blue); text-decoration: none; font-weight: 600;">← Back to SpidyUrl</a>
        </nav>
        
        <div class="page-header">
            <h1>🕷️ About SpidyUrl</h1>
            <p>Weaving the web with professional URL shortening</p>
        </div>
        
        <div class="content-wrapper">
            <section class="content-section">
                <h2>Our Mission</h2>
                <p>At SpidyUrl, we believe that every link should be clean, professional, and efficient. Our mission is to provide the most reliable and user-friendly URL shortening service on the web, helping individuals and businesses create memorable, trackable links that enhance their digital presence.</p>
            </section>

            <section class="content-section">
                <h2>What We Do</h2>
                <p>SpidyUrl is a professional URL shortening service that transforms long, complex URLs into clean, manageable links. Like a spider weaving its web, we create connections across the internet that are both elegant and functional.</p>
                
                <div class="features-grid">
                    <div class="feature-item">
                        <h3>🚀 Lightning Fast</h3>
                        <p>Our optimized infrastructure ensures your shortened URLs redirect quickly and reliably.</p>
                    </div>
                    <div class="feature-item">
                        <h3>🔒 Secure & Safe</h3>
                        <p>We implement industry-standard security measures to protect your links and data.</p>
                    </div>
                    <div class="feature-item">
                        <h3>📱 Mobile Friendly</h3>
                        <p>Our responsive design works perfectly on all devices, from desktop to mobile.</p>
                    </div>
                    <div class="feature-item">
                        <h3>🔗 Smart Linking</h3>
                        <p>Intelligent duplicate detection prevents unnecessary short links for the same URL.</p>
                    </div>
                </div>
            </section>

            <section class="content-section">
                <h2>Why Choose SpidyUrl?</h2>
                <ul class="benefits-list">
                    <li><strong>Professional Quality:</strong> Enterprise-grade infrastructure for reliable service</li>
                    <li><strong>User Privacy:</strong> We respect your privacy and don't track personal information</li>
                    <li><strong>No Registration Required:</strong> Start shortening URLs immediately without signup</li>
                    <li><strong>Clean URLs:</strong> Generate professional-looking short links for your brand</li>
                    <li><strong>Duplicate Prevention:</strong> Smart system prevents duplicate short URLs</li>
                    <li><strong>24/7 Availability:</strong> Our service is available around the clock</li>
                </ul>
            </section>

            <section class="content-section">
                <h2>Our Technology</h2>
                <p>SpidyUrl is built with modern web technologies to ensure optimal performance, security, and reliability:</p>
                <ul class="tech-list">
                    <li>PHP backend with secure prepared statements</li>
                    <li>MySQL database with optimized indexing</li>
                    <li>Responsive CSS design for all screen sizes</li>
                    <li>Advanced URL validation and sanitization</li>
                    <li>SEO-friendly 301 redirects</li>
                </ul>
            </section>

            <section class="content-section">
                <h2>Contact Us</h2>
                <p>Have questions or feedback? We'd love to hear from you!</p>
                <div class="contact-info">
                    <p><strong>Email:</strong> <a href="mailto:contact@spidyurl.com">contact@spidyurl.com</a></p>
                    <p><strong>Support:</strong> <a href="/contact.php">Contact Form</a></p>
                </div>
            </section>
        </div>
        
        <footer>
            <p>&copy; 2024 SpidyUrl. Professional URL Shortener Service.</p>
            <div class="footer-links">
                <a href="/">Home</a> |
                <a href="/contact.php">Contact</a> |
                <a href="/blog.php">Blog</a> |
                <a href="/privacy.php">Privacy Policy</a> |
                <a href="/terms.php">Terms of Service</a> |
                <a href="/cookies.php">Cookie Policy</a>
            </div>
        </footer>
    </div>

    <style>
        body {
            padding-bottom: 4rem;
        }
        
        .page-header {
            text-align: center;
            margin-bottom: 3rem;
            padding: 2rem 0;
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--secondary-blue) 100%);
            color: white;
            border-radius: var(--border-radius-lg);
            margin: 0 -1rem 3rem;
        }

        .page-header h1 {
            font-size: clamp(2rem, 5vw, 3rem);
            margin-bottom: 0.5rem;
        }

        .content-wrapper {
            max-width: 800px;
            margin: 0 auto;
        }

        .content-section {
            background: var(--background-white);
            padding: 2rem;
            margin-bottom: 2rem;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
        }

        .content-section h2 {
            color: var(--primary-blue);
            margin-bottom: 1rem;
            font-size: 1.5rem;
        }

        .content-section h3 {
            color: var(--text-dark);
            margin-bottom: 0.5rem;
            font-size: 1.1rem;
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-top: 1.5rem;
        }

        .feature-item {
            padding: 1.5rem;
            background: var(--background-light);
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
        }

        .benefits-list, .tech-list {
            list-style: none;
            padding: 0;
        }

        .benefits-list li, .tech-list li {
            padding: 0.75rem 0;
            border-left: 3px solid var(--primary-blue);
            padding-left: 1rem;
            margin-bottom: 0.5rem;
            background: var(--background-light);
            border-radius: 0 var(--border-radius) var(--border-radius) 0;
        }

        .contact-info {
            background: var(--background-light);
            padding: 1.5rem;
            border-radius: var(--border-radius);
            margin-top: 1rem;
        }

        .contact-info a {
            color: var(--primary-blue);
            text-decoration: none;
        }

        .contact-info a:hover {
            text-decoration: underline;
        }

        .footer-links {
            margin-top: 1rem;
        }

        .footer-links a {
            color: var(--text-light);
            text-decoration: none;
            margin: 0 0.5rem;
        }

        .footer-links a:hover {
            color: var(--primary-blue);
        }

        @media (max-width: 768px) {
            .page-header {
                margin: 0 -0.5rem 2rem;
                padding: 1.5rem 1rem;
            }

            .content-section {
                padding: 1.5rem;
            }

            .features-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .feature-item {
                padding: 1rem;
            }
        }
    </style>
</body>
</html>